
schedule("safariApp", initSafariApp);

var iconWidth = 48;




function initSafariApp()
{
	var safariIcon = document.getElementById("safariIcon");
	var safariAppDrag = document.getElementById("safariAppDrag");
	var safariAppClose = document.getElementById("safariAppClose");
	var safariAppAddressBar = document.getElementById("safariAppAddressBar");
	var safariBookmarkTMIB = document.getElementById("safariBookmarkTMIB");

	attachEventListener(safariBookmarkTMIB, "click", clickBookmark, false);

	attachEventListener(safariIcon, "mousedown", mousedownSafariIcon, false);
	attachEventListener(safariIcon, "mouseup", mouseupSafariIcon, false);
	attachEventListener(safariIcon, "click", clickSafariIcon, false);
	attachEventListener(safariIcon, "mouseout", mouseupSafariIcon, false);
	
	attachEventListener(safariAppDrag, "mousedown", mousedownSafariAppDrag, false);
	
	attachEventListener(safariAppClose, "click", clickSafariAppClose, false);
	
	attachEventListener(safariAppAddressBar, "click", clickSafariAppAddressBar, false);
	attachEventListener(safariAppAddressBar, "keypress", keypressSafariAppAddressBar, false);

	return true;
}




function mousedownSafariIcon()
{
	this.src = "images/application_icon_safari_selected.png";
	
	return true;
}




function mouseupSafariIcon()
{
	this.src = "images/application_icon_safari.png";
	
	return true;
}




function clickSafariIcon()
{
	var safariApp = document.getElementById("safariApp");
	var safariMenuArray = ["Safari", "File", "Edit", "View", "History", "Bookmarks", "Window", "Help", "Debug"];
	
	if (document.getElementById("safariMinimised") != null)
	{
		clickSafariMinimised();
	}
	else
	{	
		safariApp.style.display = "block";

		writeSystemMenu(safariMenuArray);
	}
	
	return true;
}




function mousedownSafariAppDrag(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	this.originalX = event.clientX;
	this.originalY = event.clientY;
	
	attachEventListener(document, "mousemove", mousemoveSafariAppDrag, false);
	attachEventListener(document, "mouseup", mouseupSafariAppDrag, false);
	
	return true;
}




function mouseupSafariAppDrag()
{
	detachEventListener(document, "mousemove", mousemoveSafariAppDrag, false);
	
	return true;
}




function mousemoveSafariAppDrag(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	var safariApp = document.getElementById("safariApp");
	var safariAppDrag = document.getElementById("safariAppDrag");
	var currLeft = parseInt(retrieveComputedStyle(safariApp, "left"));
	var currTop = parseInt(retrieveComputedStyle(safariApp, "top"));
	
	safariApp.style.left = currLeft + (event.clientX - safariAppDrag.originalX) + "px";
	safariApp.style.top = currTop + (event.clientY - safariAppDrag.originalY) + "px";
	
	safariAppDrag.originalX = event.clientX;
	safariAppDrag.originalY = event.clientY;
	
	return true;
}




function clickSafariAppClose()
{
	var dock = document.getElementById("dock");
	var icons = dock.getElementsByTagName("img");
	var safariApp = document.getElementById("safariApp");
	var image = document.createElement("img");
	var shrinker = document.createElement("div");
	var systemMenuArray = ["Finder", "File", "Edit", "View", "Go", "Window"];
	
	image.id = "safariMinimised";
	image.src = "images/safari_icon_minimised.png";
	image.style.width = iconWidth + "px";
	image.style.height = image.style.width;
	attachEventListener(image, "mousedown", mousedownSafariMinimised, false);
	attachEventListener(image, "mouseup", mouseupSafariMinimised, false);
	attachEventListener(image, "click", clickSafariMinimised, false);
	
	icons[0].parentNode.insertBefore(image, icons[7]);
	
	refreshDockDisplay();
	
	writeSystemMenu(systemMenuArray);

	shrinker.id = "shrinker";
	shrinker.style.left = safariApp.offsetLeft + 7 + "px";
	shrinker.style.top = safariApp.offsetTop + 2 + "px";
	shrinker.style.width = safariApp.offsetWidth - 16 + "px";
	shrinker.style.height = safariApp.offsetHeight - 16 + "px";
	shrinker = document.getElementsByTagName("body")[0].appendChild(shrinker);
	
	safariApp.style.display = "none";
	
	shrink(shrinker, image);
	
	return true;
}




function shrink(target, destination)
{
	var currLeft = parseInt(retrieveComputedStyle(target, "left"));
	var currTop = parseInt(retrieveComputedStyle(target, "top"));
	var destinationPosition = getPosition(destination);
	var scaleIncrement = 7;

	if (typeof target.originalLeft == "undefined")
	{
		target.originalLeft = parseInt(retrieveComputedStyle(target, "left"));
		target.originalTop = parseInt(retrieveComputedStyle(target, "top"));
		target.originalWidth = target.offsetWidth;
		target.originalHeight = target.offsetHeight;
	}

	if (currLeft > destinationPosition[0] - parseInt((destinationPosition[0] - target.originalLeft) / scaleIncrement))
	{
		target.parentNode.removeChild(target);
	}
	else
	{
		target.style.left = currLeft + parseInt((destinationPosition[0] - target.originalLeft) / scaleIncrement) + "px";
		target.style.top = currTop + parseInt((destinationPosition[1] - target.originalTop) / scaleIncrement) + "px";
		
		target.style.width = target.offsetWidth - parseInt(target.originalWidth / scaleIncrement) + "px";
		target.style.height = target.offsetHeight - parseInt(target.originalHeight / scaleIncrement) + "px";

		setTimeout(function(){shrink(target, destination)}, 25);
	}
	
	return true;
}




function mousedownSafariMinimised()
{
	this.src = "images/safari_icon_minimised_selected.png";
	
	return true;
}




function mouseupSafariMinimised()
{
	this.src = "images/safari_icon_minimised.png";
	
	return true;
}




function clickSafariMinimised()
{
	var safariApp = document.getElementById("safariApp");
	var dock = document.getElementById("dock");
	var safariMenuArray = ["Safari", "File", "Edit", "View", "History", "Bookmarks", "Window", "Help", "Debug"];
	
	safariApp.style.display = "block";

	detachEventListener(dock, "mousemove", mousemoveDock, false);

	removeIcon(document.getElementById("safariMinimised"));

	writeSystemMenu(safariMenuArray);
	
	return true;
}





function removeIcon(target)
{
	var increment = 10;
	var currWidth = parseInt(target.style.width);
	
	target.style.width = currWidth - increment + "px";
	target.style.height = target.style.width;
	
	refreshDockDisplay();
	
	if (currWidth < increment)
	{
		var dock = document.getElementById("dock");
		
		target.parentNode.removeChild(target);
		attachEventListener(dock, "mousemove", mousemoveDock, false);
	}
	else
	{
		setTimeout(function(){removeIcon(target)}, 25);
	}
	
	return true;
}




function clickSafariAppAddressBar()
{
	this.style.backgroundColor = "#FFFFFF";
	
	return true;
}




function keypressSafariAppAddressBar(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	var safariAppIframe = document.getElementById("safariAppIframe");
	
	if (event.keyCode == "13")
	{
		if (!this.value.match(/^http:\/\//))
		{
			this.value = "http://" + this.value;
		}
		
		safariAppIframe.src = this.value;
	}
	
	return true;
}




function clickMenuItem(event)
{
	if (typeof event == "undefined")
	{
		event = window.event;
	}
	
	var safariBookmarks = document.getElementById("safariBookmarks");

	safariBookmarks.style.left = this.offsetLeft + "px";

	if (safariBookmarks.style.display == "block")
	{
		safariBookmarks.style.display = "none";
	}
	else
	{
		safariBookmarks.style.display = "block";
	}
	
	return true;
}




function clickBookmark()
{
	var safariBookmarks = document.getElementById("safariBookmarks");
	var safariAppAddressBar = document.getElementById("safariAppAddressBar");
	var safariAppIframe = document.getElementById("safariAppIframe");

	safariBookmarks.style.display = "none";
	safariAppAddressBar.style.backgroundColor = "#FFFFFF";
	safariAppAddressBar.value = "http://www.themaninblue.com/writing/";
	safariAppIframe.src = safariAppAddressBar.value;

	return true;
}
